/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.listener.DeleteByIdListener;
import org.codefilarete.stalactite.engine.listener.DeleteListener;
import org.codefilarete.stalactite.engine.listener.InsertListener;
import org.codefilarete.stalactite.engine.listener.PersistListener;
import org.codefilarete.stalactite.engine.listener.PersisterListenerCollection;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.engine.listener.UpdateByIdListener;
import org.codefilarete.stalactite.engine.listener.UpdateListener;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PersisterListenerCollectionTest {
    @Test
    public void doWithSelectListener() {
        PersisterListenerCollection testInstance = new PersisterListenerCollection();
        SelectListener listenerMock = (SelectListener)Mockito.mock(SelectListener.class);
        testInstance.addSelectListener(listenerMock);
        ArrayList entities = new ArrayList();
        HashSet result = new HashSet();
        Assertions.assertThat((Collection)testInstance.doWithSelectListener(entities, () -> result)).isEqualTo(result);
        ((SelectListener)Mockito.verify((Object)listenerMock)).beforeSelect((Iterable)ArgumentMatchers.eq(entities));
        ((SelectListener)Mockito.verify((Object)listenerMock)).afterSelect((Set)ArgumentMatchers.eq(result));
    }

    @Test
    public void doWithSelectListener_onError() {
        PersisterListenerCollection testInstance = new PersisterListenerCollection();
        SelectListener listenerMock = (SelectListener)Mockito.mock(SelectListener.class);
        testInstance.addSelectListener(listenerMock);
        ArrayList entities = new ArrayList();
        RuntimeException error = new RuntimeException("This is the expected exception to be thrown");
        Assertions.assertThatThrownBy(() -> testInstance.doWithSelectListener((Iterable)entities, () -> {
            throw error;
        })).isSameAs((Object)error);
        ((SelectListener)Mockito.verify((Object)listenerMock)).beforeSelect((Iterable)ArgumentMatchers.eq(entities));
        ((SelectListener)Mockito.verify((Object)listenerMock)).onSelectError((Iterable)ArgumentMatchers.eq(entities), (RuntimeException)ArgumentMatchers.eq((Object)error));
        ((SelectListener)Mockito.verify((Object)listenerMock, (VerificationMode)Mockito.never())).afterSelect(ArgumentMatchers.anySet());
    }

    @Test
    public void doWithPersistListener() {
        PersisterListenerCollection testInstance = new PersisterListenerCollection();
        PersistListener listenerMock = (PersistListener)Mockito.mock(PersistListener.class);
        testInstance.addPersistListener(listenerMock);
        ArrayList entities = new ArrayList();
        ArrayList result = new ArrayList();
        Assertions.assertThat((Object)testInstance.doWithPersistListener(entities, () -> result)).isEqualTo(result);
        ((PersistListener)Mockito.verify((Object)listenerMock)).beforePersist((Iterable)ArgumentMatchers.eq(entities));
        ((PersistListener)Mockito.verify((Object)listenerMock)).afterPersist((Iterable)ArgumentMatchers.eq(result));
    }

    @Test
    public void doWithPersistListener_onError() {
        PersisterListenerCollection testInstance = new PersisterListenerCollection();
        PersistListener listenerMock = (PersistListener)Mockito.mock(PersistListener.class);
        testInstance.addPersistListener(listenerMock);
        ArrayList entities = new ArrayList();
        RuntimeException error = new RuntimeException("This is the expected exception to be thrown");
        Assertions.assertThatThrownBy(() -> testInstance.doWithPersistListener((Iterable)entities, () -> {
            throw error;
        })).isSameAs((Object)error);
        ((PersistListener)Mockito.verify((Object)listenerMock)).beforePersist((Iterable)ArgumentMatchers.eq(entities));
        ((PersistListener)Mockito.verify((Object)listenerMock)).onPersistError((Iterable)ArgumentMatchers.eq(entities), (RuntimeException)ArgumentMatchers.eq((Object)error));
        ((PersistListener)Mockito.verify((Object)listenerMock, (VerificationMode)Mockito.never())).afterPersist(ArgumentMatchers.anyIterable());
    }

    @Test
    public void doWithInsertListener() {
        PersisterListenerCollection testInstance = new PersisterListenerCollection();
        InsertListener listenerMock = (InsertListener)Mockito.mock(InsertListener.class);
        testInstance.addInsertListener(listenerMock);
        ArrayList entities = new ArrayList();
        ArrayList result = new ArrayList();
        Assertions.assertThat((Object)testInstance.doWithInsertListener(entities, () -> result)).isEqualTo(result);
        ((InsertListener)Mockito.verify((Object)listenerMock)).beforeInsert((Iterable)ArgumentMatchers.eq(entities));
        ((InsertListener)Mockito.verify((Object)listenerMock)).afterInsert((Iterable)ArgumentMatchers.eq(result));
    }

    @Test
    public void doWithInsertListener_onError() {
        PersisterListenerCollection testInstance = new PersisterListenerCollection();
        InsertListener listenerMock = (InsertListener)Mockito.mock(InsertListener.class);
        testInstance.addInsertListener(listenerMock);
        ArrayList entities = new ArrayList();
        RuntimeException error = new RuntimeException("This is the expected exception to be thrown");
        Assertions.assertThatThrownBy(() -> testInstance.doWithInsertListener((Iterable)entities, () -> {
            throw error;
        })).isSameAs((Object)error);
        ((InsertListener)Mockito.verify((Object)listenerMock)).beforeInsert((Iterable)ArgumentMatchers.eq(entities));
        ((InsertListener)Mockito.verify((Object)listenerMock)).onInsertError((Iterable)ArgumentMatchers.eq(entities), (RuntimeException)ArgumentMatchers.eq((Object)error));
        ((InsertListener)Mockito.verify((Object)listenerMock, (VerificationMode)Mockito.never())).afterInsert(ArgumentMatchers.anyIterable());
    }

    @Test
    public void doWithUpdateListener() {
        PersisterListenerCollection testInstance = new PersisterListenerCollection();
        UpdateListener listenerMock = (UpdateListener)Mockito.mock(UpdateListener.class);
        testInstance.addUpdateListener(listenerMock);
        ArrayList entities = new ArrayList();
        ArrayList result = new ArrayList();
        Assertions.assertThat((Object)testInstance.doWithUpdateListener(entities, true, () -> result)).isEqualTo(result);
        ((UpdateListener)Mockito.verify((Object)listenerMock)).beforeUpdate((Iterable)ArgumentMatchers.eq(entities), ArgumentMatchers.eq((boolean)true));
        ((UpdateListener)Mockito.verify((Object)listenerMock)).afterUpdate((Iterable)ArgumentMatchers.eq(result), ArgumentMatchers.eq((boolean)true));
    }

    @Test
    public void doWithUpdateListener_onError() {
        PersisterListenerCollection testInstance = new PersisterListenerCollection();
        UpdateListener listenerMock = (UpdateListener)Mockito.mock(UpdateListener.class);
        testInstance.addUpdateListener(listenerMock);
        ArrayList entities = new ArrayList();
        RuntimeException error = new RuntimeException("This is the expected exception to be thrown");
        Assertions.assertThatThrownBy(() -> testInstance.doWithUpdateListener((Iterable)entities, true, () -> {
            throw error;
        })).isSameAs((Object)error);
        ((UpdateListener)Mockito.verify((Object)listenerMock)).beforeUpdate((Iterable)ArgumentMatchers.eq(entities), ArgumentMatchers.eq((boolean)true));
        ((UpdateListener)Mockito.verify((Object)listenerMock)).onUpdateError((Iterable)ArgumentMatchers.eq(entities), (RuntimeException)ArgumentMatchers.eq((Object)error));
        ((UpdateListener)Mockito.verify((Object)listenerMock, (VerificationMode)Mockito.never())).afterUpdate(ArgumentMatchers.anyIterable(), ArgumentMatchers.eq((boolean)true));
    }

    @Test
    public void doWithUpdateByIdListener() {
        PersisterListenerCollection testInstance = new PersisterListenerCollection();
        UpdateByIdListener listenerMock = (UpdateByIdListener)Mockito.mock(UpdateByIdListener.class);
        testInstance.addUpdateByIdListener(listenerMock);
        ArrayList entities = new ArrayList();
        ArrayList result = new ArrayList();
        Assertions.assertThat((Object)testInstance.doWithUpdateByIdListener(entities, () -> result)).isEqualTo(result);
        ((UpdateByIdListener)Mockito.verify((Object)listenerMock)).beforeUpdateById((Iterable)ArgumentMatchers.eq(entities));
        ((UpdateByIdListener)Mockito.verify((Object)listenerMock)).afterUpdateById((Iterable)ArgumentMatchers.eq(result));
    }

    @Test
    public void doWithUpdateByIdListener_onError() {
        PersisterListenerCollection testInstance = new PersisterListenerCollection();
        UpdateByIdListener listenerMock = (UpdateByIdListener)Mockito.mock(UpdateByIdListener.class);
        testInstance.addUpdateByIdListener(listenerMock);
        ArrayList entities = new ArrayList();
        RuntimeException error = new RuntimeException("This is the expected exception to be thrown");
        Assertions.assertThatThrownBy(() -> testInstance.doWithUpdateByIdListener((Iterable)entities, () -> {
            throw error;
        })).isSameAs((Object)error);
        ((UpdateByIdListener)Mockito.verify((Object)listenerMock)).beforeUpdateById((Iterable)ArgumentMatchers.eq(entities));
        ((UpdateByIdListener)Mockito.verify((Object)listenerMock)).onUpdateError((Iterable)ArgumentMatchers.eq(entities), (RuntimeException)ArgumentMatchers.eq((Object)error));
        ((UpdateByIdListener)Mockito.verify((Object)listenerMock, (VerificationMode)Mockito.never())).afterUpdateById(ArgumentMatchers.anyIterable());
    }

    @Test
    public void doWithDeleteListener() {
        PersisterListenerCollection testInstance = new PersisterListenerCollection();
        DeleteListener listenerMock = (DeleteListener)Mockito.mock(DeleteListener.class);
        testInstance.addDeleteListener(listenerMock);
        ArrayList entities = new ArrayList();
        ArrayList result = new ArrayList();
        Assertions.assertThat((Object)testInstance.doWithDeleteListener(entities, () -> result)).isEqualTo(result);
        ((DeleteListener)Mockito.verify((Object)listenerMock)).beforeDelete((Iterable)ArgumentMatchers.eq(entities));
        ((DeleteListener)Mockito.verify((Object)listenerMock)).afterDelete((Iterable)ArgumentMatchers.eq(result));
    }

    @Test
    public void doWithDeleteListener_onError() {
        PersisterListenerCollection testInstance = new PersisterListenerCollection();
        DeleteListener listenerMock = (DeleteListener)Mockito.mock(DeleteListener.class);
        testInstance.addDeleteListener(listenerMock);
        ArrayList entities = new ArrayList();
        RuntimeException error = new RuntimeException("This is the expected exception to be thrown");
        Assertions.assertThatThrownBy(() -> testInstance.doWithDeleteListener((Iterable)entities, () -> {
            throw error;
        })).isSameAs((Object)error);
        ((DeleteListener)Mockito.verify((Object)listenerMock)).beforeDelete((Iterable)ArgumentMatchers.eq(entities));
        ((DeleteListener)Mockito.verify((Object)listenerMock)).onDeleteError((Iterable)ArgumentMatchers.eq(entities), (RuntimeException)ArgumentMatchers.eq((Object)error));
        ((DeleteListener)Mockito.verify((Object)listenerMock, (VerificationMode)Mockito.never())).afterDelete(ArgumentMatchers.anyIterable());
    }

    @Test
    public void doWithDeleteByIdListener() {
        PersisterListenerCollection testInstance = new PersisterListenerCollection();
        DeleteByIdListener listenerMock = (DeleteByIdListener)Mockito.mock(DeleteByIdListener.class);
        testInstance.addDeleteByIdListener(listenerMock);
        ArrayList entities = new ArrayList();
        ArrayList result = new ArrayList();
        Assertions.assertThat((Object)testInstance.doWithDeleteByIdListener(entities, () -> result)).isEqualTo(result);
        ((DeleteByIdListener)Mockito.verify((Object)listenerMock)).beforeDeleteById((Iterable)ArgumentMatchers.eq(entities));
        ((DeleteByIdListener)Mockito.verify((Object)listenerMock)).afterDeleteById((Iterable)ArgumentMatchers.eq(result));
    }

    @Test
    public void doWithDeleteByIdListener_onError() {
        PersisterListenerCollection testInstance = new PersisterListenerCollection();
        DeleteByIdListener listenerMock = (DeleteByIdListener)Mockito.mock(DeleteByIdListener.class);
        testInstance.addDeleteByIdListener(listenerMock);
        ArrayList entities = new ArrayList();
        RuntimeException error = new RuntimeException("This is the expected exception to be thrown");
        Assertions.assertThatThrownBy(() -> testInstance.doWithDeleteByIdListener((Iterable)entities, () -> {
            throw error;
        })).isSameAs((Object)error);
        ((DeleteByIdListener)Mockito.verify((Object)listenerMock)).beforeDeleteById((Iterable)ArgumentMatchers.eq(entities));
        ((DeleteByIdListener)Mockito.verify((Object)listenerMock)).onDeleteError((Iterable)ArgumentMatchers.eq(entities), (RuntimeException)ArgumentMatchers.eq((Object)error));
        ((DeleteByIdListener)Mockito.verify((Object)listenerMock, (VerificationMode)Mockito.never())).afterDeleteById(ArgumentMatchers.anyIterable());
    }

    @Test
    public void moveTo() {
        PersisterListenerCollection testInstance = new PersisterListenerCollection();
        PersisterListenerCollection targetInstance = new PersisterListenerCollection();
        InsertListener expectedInsertListener = (InsertListener)Mockito.mock(InsertListener.class);
        UpdateListener expectedUpdateListener = (UpdateListener)Mockito.mock(UpdateListener.class);
        UpdateByIdListener expectedUpdateByIdListener = (UpdateByIdListener)Mockito.mock(UpdateByIdListener.class);
        DeleteListener expectedDeleteListener = (DeleteListener)Mockito.mock(DeleteListener.class);
        DeleteByIdListener expectedDeleteByIdListener = (DeleteByIdListener)Mockito.mock(DeleteByIdListener.class);
        SelectListener expectedSelectListener = (SelectListener)Mockito.mock(SelectListener.class);
        testInstance.addInsertListener(expectedInsertListener);
        testInstance.addUpdateListener(expectedUpdateListener);
        testInstance.addUpdateByIdListener(expectedUpdateByIdListener);
        testInstance.addDeleteListener(expectedDeleteListener);
        testInstance.addDeleteByIdListener(expectedDeleteByIdListener);
        testInstance.addSelectListener(expectedSelectListener);
        testInstance.moveTo(targetInstance);
        List entities = Arrays.asList((Object[])new Object[]{new Object()});
        testInstance.doWithInsertListener((Iterable)entities, () -> 1);
        ((InsertListener)Mockito.verify((Object)expectedInsertListener, (VerificationMode)Mockito.times((int)0))).beforeInsert((Iterable)ArgumentMatchers.eq((Object)entities));
        ((InsertListener)Mockito.verify((Object)expectedInsertListener, (VerificationMode)Mockito.times((int)0))).afterInsert((Iterable)ArgumentMatchers.eq((Object)entities));
        List updatableEntities = Arrays.asList((Object[])new Duo[]{new Duo(new Object(), new Object())});
        testInstance.doWithUpdateListener((Iterable)updatableEntities, true, () -> Void.class);
        ((UpdateListener)Mockito.verify((Object)expectedUpdateListener, (VerificationMode)Mockito.times((int)0))).beforeUpdate((Iterable)ArgumentMatchers.eq((Object)updatableEntities), ArgumentMatchers.eq((boolean)true));
        ((UpdateListener)Mockito.verify((Object)expectedUpdateListener, (VerificationMode)Mockito.times((int)0))).afterUpdate((Iterable)ArgumentMatchers.eq((Object)updatableEntities), ArgumentMatchers.eq((boolean)true));
        testInstance.doWithUpdateByIdListener((Iterable)entities, () -> 1);
        ((UpdateByIdListener)Mockito.verify((Object)expectedUpdateByIdListener, (VerificationMode)Mockito.times((int)0))).beforeUpdateById((Iterable)ArgumentMatchers.eq((Object)entities));
        ((UpdateByIdListener)Mockito.verify((Object)expectedUpdateByIdListener, (VerificationMode)Mockito.times((int)0))).afterUpdateById((Iterable)ArgumentMatchers.eq((Object)entities));
        testInstance.doWithDeleteListener((Iterable)entities, () -> 1);
        ((DeleteListener)Mockito.verify((Object)expectedDeleteListener, (VerificationMode)Mockito.times((int)0))).beforeDelete((Iterable)ArgumentMatchers.eq((Object)entities));
        ((DeleteListener)Mockito.verify((Object)expectedDeleteListener, (VerificationMode)Mockito.times((int)0))).afterDelete((Iterable)ArgumentMatchers.eq((Object)entities));
        testInstance.doWithDeleteByIdListener((Iterable)entities, () -> 1);
        ((DeleteByIdListener)Mockito.verify((Object)expectedDeleteByIdListener, (VerificationMode)Mockito.times((int)0))).beforeDeleteById((Iterable)ArgumentMatchers.eq((Object)entities));
        ((DeleteByIdListener)Mockito.verify((Object)expectedDeleteByIdListener, (VerificationMode)Mockito.times((int)0))).afterDeleteById((Iterable)ArgumentMatchers.eq((Object)entities));
        List entitiesIds = Arrays.asList((Object[])new Object[]{new Object()});
        HashSet loadedEntities = new HashSet();
        testInstance.doWithSelectListener((Iterable)entitiesIds, () -> loadedEntities);
        ((SelectListener)Mockito.verify((Object)expectedSelectListener, (VerificationMode)Mockito.times((int)0))).beforeSelect((Iterable)ArgumentMatchers.eq((Object)entitiesIds));
        ((SelectListener)Mockito.verify((Object)expectedSelectListener, (VerificationMode)Mockito.times((int)0))).afterSelect((Set)ArgumentMatchers.eq(loadedEntities));
        targetInstance.doWithInsertListener((Iterable)entities, () -> 1);
        ((InsertListener)Mockito.verify((Object)expectedInsertListener)).beforeInsert((Iterable)ArgumentMatchers.eq((Object)entities));
        ((InsertListener)Mockito.verify((Object)expectedInsertListener)).afterInsert((Iterable)ArgumentMatchers.eq((Object)entities));
        targetInstance.doWithUpdateListener((Iterable)updatableEntities, true, () -> Void.class);
        ((UpdateListener)Mockito.verify((Object)expectedUpdateListener)).beforeUpdate((Iterable)ArgumentMatchers.eq((Object)updatableEntities), ArgumentMatchers.eq((boolean)true));
        ((UpdateListener)Mockito.verify((Object)expectedUpdateListener)).afterUpdate((Iterable)ArgumentMatchers.eq((Object)updatableEntities), ArgumentMatchers.eq((boolean)true));
        targetInstance.doWithUpdateByIdListener((Iterable)entities, () -> 1);
        ((UpdateByIdListener)Mockito.verify((Object)expectedUpdateByIdListener)).beforeUpdateById((Iterable)ArgumentMatchers.eq((Object)entities));
        ((UpdateByIdListener)Mockito.verify((Object)expectedUpdateByIdListener)).afterUpdateById((Iterable)ArgumentMatchers.eq((Object)entities));
        targetInstance.doWithDeleteListener((Iterable)entities, () -> 1);
        ((DeleteListener)Mockito.verify((Object)expectedDeleteListener)).beforeDelete((Iterable)ArgumentMatchers.eq((Object)entities));
        ((DeleteListener)Mockito.verify((Object)expectedDeleteListener)).afterDelete((Iterable)ArgumentMatchers.eq((Object)entities));
        targetInstance.doWithDeleteByIdListener((Iterable)entities, () -> 1);
        ((DeleteByIdListener)Mockito.verify((Object)expectedDeleteByIdListener)).beforeDeleteById((Iterable)ArgumentMatchers.eq((Object)entities));
        ((DeleteByIdListener)Mockito.verify((Object)expectedDeleteByIdListener)).afterDeleteById((Iterable)ArgumentMatchers.eq((Object)entities));
        targetInstance.doWithSelectListener((Iterable)entitiesIds, () -> loadedEntities);
        ((SelectListener)Mockito.verify((Object)expectedSelectListener)).beforeSelect((Iterable)ArgumentMatchers.eq((Object)entitiesIds));
        ((SelectListener)Mockito.verify((Object)expectedSelectListener)).afterSelect((Set)ArgumentMatchers.eq(loadedEntities));
    }
}

